# HydroQC - Hydro Quebec API wrapper

**This is a library to use if you want to build your own solution. If you want a user-friendly implementation for your home automation system please use [hydroqc2mqtt](https://gitlab.com/hydroqc/hydroqc2mqtt) which provide a MQTT publisher, docker image and HASS addon.**

This is a package to access some functionalities of Hydro Quebec API that are not documented.

We started a discord server for the project where you can come to discuss and find help with the project [https://discord.gg/NWnfdfRZ7T](https://discord.gg/NWnfdfRZ7T)

## Documentation

### Code documentation

[https://hydroqc.readthedocs.io/](https://hydroqc.readthedocs.io/)

### Architecture / concepts

If you need more information about the winter credit, the associated terms, documents, ... :
   [Winter Credit lexicon and concepts](https://hydroqc.readthedocs.io/en/latest/wintercredit/wintercredit.html)

## Credit

- [piaf](https://gitlab.com/zepiaf) who revived the flame for a Hydro-Quebec API component, started this project and uncovered some new Hydro-Quebec APIs that are being used in this project.
- [titilambert](https://gitlab.com/titilambert) who wrote [pyhydroquebec](https://github.com/titilambert/pyhydroquebec/) and is now actively developping with us on this project.
- [mdallaire](https://gitlab.com/mdallaire1) helps with the documentation, testing and provides some architecture feedback.

## Goal

Make it easy to fetch and manipulate data from Hydro-Quebec, especially the winter credit periods

## Example folder

An example script that extracts the data available from Hydro-Quebec is available in the examples folder.

### Basic setup

This uses python 3 (tested with 3.8)

1. Clone the repo

   ```bash
   git clone https://gitlab.com/hydroqc/hydroqc.git
   ```

2. Create a virtual-env

   ```bash
   python -m venv env
   . env/bin/activate
   pip install -r requirements.txt
   python setup.py develop 
   ```

3. Enter your hydro account credentials in the examples/hydro.py file (line 6)

4. Run

   ```bash
   examples/hydro.py
   ```

## Available features

- Services.getWinterCredit() to get raw winter credit data
- Services.getTodayHourlyConsumption() to get raw hourly consumption for current day
- Services.getHourlyConsumption(date = 'YYYY-MM-DD') to get hourly consumption for specific day
- Services.getDailyConsumption(start_date = 'YYYY-MM-DD',end_date = 'YYYY-MM-DD') to get a range of daily consumption
- WinterCredit.getFutureEvents() to get a list of JSON object with future peak events

An incomplete (so far) list of possible values and their meanings are being documented here : [https://hydroqc.readthedocs.io/en/latest/wintercredit/values.html](https://hydroqc.readthedocs.io/en/latest/wintercredit/values.html)

## NOTES

As per issue [https://github.com/zepiaf/hydroqc/issues/11](https://github.com/zepiaf/hydroqc/issues/11) the full certificate chain for "session.hydroquebec.com" is not provided completely by Hydro-Quebec, resulting in a failed SSL verification. We are providing it in the "hydro-chain.pem" file and the code is using this file to validate the certificate in queries to "session.hydroquebec.com".

We would very much like for this to be either fixed by Hydro-Quebec or for this chain to be dynamicaly built at run time. Any help to make this happen would be greatly appreciated.

## TODO

[https://gitlab.com/groups/hydroqc/-/issues](https://gitlab.com/groups/hydroqc/-/issues)

## Targeted architecture (might change in the future)

```mermaid
classDiagram
    WebUser <-- Customer
    WebUser <-- HydroClient

    Customer <-- Account

    Account <-- Contract

    Contract <-- HydroClient
    Contract <-- Period
    Contract <-- Event
    Contract <-- WinterCreditHelper

    WinterCreditHelper <-- HydroClient


    HydroClient <-- Authenticator

    class HydroClient{

    }
    class WinterCreditHelper{
    }
    
    class WebUser{
        -HydroClient _hydro_client
        +List~Customer~ customers
        +get_contracts()
    }

    class Customer{
        -HydroClient _hydro_client
        +List~Account~ accounts
    }

    class Account{
        -HydroClient _hydro_client
        +List~Contract~ contracts
    }

    class Config{
        -string config_file_path
    }

    class Contract{
        -HydroClient _hydro_client
        -int customer_id
        -int webuser_id
        +string subscription_type
        +float balance
        +list~Period~ periods
        +list~Event~ events
        +get_winter_credit()
        +fetch_periods()
        +fetch_summary()
    }

    class Period{
    }

    class Event{
    }
```
